/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute;

import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeListener;
import dev.toma.gunsrpg.api.common.attribute.IAttributeModifier;
import dev.toma.gunsrpg.api.common.attribute.IModifierOp;
import dev.toma.gunsrpg.api.common.attribute.IModifierSerializer;
import dev.toma.gunsrpg.api.common.attribute.ITickableModifier;
import dev.toma.gunsrpg.common.attribute.OperationTarget;
import dev.toma.gunsrpg.common.attribute.serialization.ModifierSerialization;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public class Attribute
implements IAttribute {
    private final IAttributeId id;
    private final Map<UUID, IAttributeModifier> modifierMap = new HashMap<UUID, IAttributeModifier>();
    private final Set<ITickableModifier> temporaryModifiers = new HashSet<ITickableModifier>();
    private final Set<IAttributeListener> listeners = new HashSet<IAttributeListener>();
    private final double baseValue;
    private boolean requireUpdate;
    private double value;

    public Attribute(IAttributeId id) {
        this.id = id;
        this.baseValue = id.getBaseValue();
        this.value = this.getBaseValue();
        this.requireUpdate = true;
    }

    @Override
    public double getModifiedValue(double value) {
        Comparator<IAttributeModifier> executionOrderSorter = Comparator.comparing(IAttributeModifier::getOperation, Comparator.comparingInt(IModifierOp::getPriority));
        HashMap<OperationTarget, List> modifiersByTarget = new HashMap<OperationTarget, List>();
        for (IAttributeModifier modifier : this.modifierMap.values()) {
            modifiersByTarget.computeIfAbsent(modifier.getOperation().getOperationTarget(), k -> new ArrayList()).add(modifier);
        }
        for (List list : modifiersByTarget.values()) {
            list.sort(executionOrderSorter);
        }
        Collection op1 = ModUtils.getNonnullFromMap(modifiersByTarget, OperationTarget.BEFORE_MULTIPLY, Collections.emptyList());
        Collection op2 = ModUtils.getNonnullFromMap(modifiersByTarget, OperationTarget.MULTIPLIER, Collections.emptyList());
        Collection op3 = ModUtils.getNonnullFromMap(modifiersByTarget, OperationTarget.AFTER_MULTIPLY, Collections.emptyList());
        double initial = this.calculate(value, op1);
        double multiplier = this.calculate(1.0, op2);
        return this.calculate(initial * multiplier, op3);
    }

    @Override
    public double value() {
        if (this.requireUpdate) {
            this.requireUpdate = false;
            this.value = this.getModifiedValue(this.baseValue);
            this.notifyListenerChange(this.value, IAttributeListener::onValueChanged);
        }
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)Math.round(this.value());
    }

    @Override
    public float floatValue() {
        return (float)this.value();
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public void markChanged() {
        this.requireUpdate = true;
    }

    @Override
    public void tickAttributes() {
        Iterator<ITickableModifier> iterator = this.temporaryModifiers.iterator();
        while (iterator.hasNext()) {
            ITickableModifier modifier = iterator.next();
            if (modifier.shouldRemove()) {
                iterator.remove();
                this.removeModifier(modifier);
                this.notifyListenerChange(modifier, IAttributeListener::onModifierRemoved);
                this.markChanged();
                continue;
            }
            modifier.tick();
        }
    }

    @Override
    public void addModifier(IAttributeModifier modifier) {
        IAttributeModifier instance = modifier.instance();
        IAttributeModifier oldModifier = this.modifierMap.put(modifier.getUid(), instance);
        if (oldModifier instanceof ITickableModifier) {
            this.temporaryModifiers.remove(oldModifier);
        }
        if (instance instanceof ITickableModifier) {
            this.temporaryModifiers.add((ITickableModifier)instance);
        }
        this.notifyListenerChange(instance, IAttributeListener::onModifierAdded);
        this.markChanged();
    }

    @Override
    public void removeModifier(IAttributeModifier modifier) {
        this.removeModifierById(modifier.getUid());
    }

    @Override
    public void removeModifierById(UUID modifierId) {
        IAttributeModifier modifier = this.modifierMap.remove(modifierId);
        if (modifier instanceof ITickableModifier) {
            this.temporaryModifiers.remove(modifier);
        }
        this.markChanged();
    }

    @Override
    public boolean hasModifier(UUID modifierId) {
        return this.modifierMap.containsKey(modifierId);
    }

    @Override
    public List<IAttributeModifier> listModifiers() {
        ArrayList<IAttributeModifier> list = new ArrayList<IAttributeModifier>(this.modifierMap.values());
        list.sort(Comparator.comparingInt(mod -> mod.getOperation().getPriority()));
        return list;
    }

    @Override
    public void addAttributeListener(IAttributeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public IAttributeId getId() {
        return this.id;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT modifiers = new ListNBT();
        for (IAttributeModifier modifier : this.modifierMap.values()) {
            modifiers.add((Object)Attribute.serializeModifier(modifier));
        }
        nbt.func_218657_a("modifiers", (INBT)modifiers);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.modifierMap.clear();
        this.temporaryModifiers.clear();
        ListNBT modifiers = nbt.func_150295_c("modifiers", 10);
        for (int i = 0; i < modifiers.size(); ++i) {
            CompoundNBT data = modifiers.func_150305_b(i);
            Object modifier = Attribute.deserializeModifier(data);
            this.modifierMap.put(modifier.getUid(), (IAttributeModifier)modifier);
            if (!(modifier instanceof ITickableModifier)) continue;
            this.temporaryModifiers.add((ITickableModifier)modifier);
        }
    }

    private <P> void notifyListenerChange(P parameter, BiConsumer<IAttributeListener, P> notifyEvent) {
        this.listeners.forEach(listener -> notifyEvent.accept((IAttributeListener)listener, parameter));
    }

    public static <M extends IAttributeModifier> CompoundNBT serializeModifier(M modifier) {
        IModifierSerializer<?> serializer = modifier.getSerializer();
        CompoundNBT data = new CompoundNBT();
        data.func_74778_a("serializer", serializer.getSerializerUid().toString());
        serializer.toNbtStructure(modifier, data);
        return data;
    }

    public static <M extends IAttributeModifier> M deserializeModifier(CompoundNBT data) {
        ResourceLocation type = new ResourceLocation(data.func_74779_i("serializer"));
        Object serializer = ModifierSerialization.getSerializer(type);
        return serializer.fromNbtStructure(data);
    }

    private double calculate(double value, Collection<IAttributeModifier> set) {
        double calculated = value;
        for (IAttributeModifier modifier : set) {
            IModifierOp op = modifier.getOperation();
            calculated = op.combine(calculated, modifier.getModifierValue());
        }
        return calculated;
    }
}

